//
// $Id: disk.cc,v 1.9 2001/07/13 15:15:06 nishi Exp $
//
// Copyright (C) 2001 Shouhei Nishi.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//





#include "bochs.h"
#include "biosregs.h"
#define LOG_THIS bx_disk_bios.


bx_disk_bios_c bx_disk_bios;
#if BX_USE_DISKBIOS_SMF
#define this (&bx_disk_bios)
#endif


bx_disk_bios_c::bx_disk_bios_c(void)
{
}

bx_disk_bios_c::~bx_disk_bios_c(void)
{
  // nothing for now
}


  void
bx_disk_bios_c::init(bx_bios_c *b)
{
  BX_DISK_BIOS_THIS bios = b;
  Bit32u biosmain_addr;
  Bit8u jmp_code;
  Bit16u jmp_off,jmp_seg;

  // Official disk BIOS entry address is 0xfffb:0x0014
  // Far jump code to main disk BIOS code is exist in this entry point.
  // But initializer of boot ROM called main disk BIOS code directly.
  // Hook in official entry point can not intercept initialize BIOS command.
  // So, we hook main disk BIOS code directly.
  bx_mem.read_physical(BX_CPU(0),0xfffc4,1,&jmp_code);
  bx_mem.read_physical(BX_CPU(0),0xfffc5,2,&jmp_off);
  bx_mem.read_physical(BX_CPU(0),0xfffc7,2,&jmp_seg);
  if(jmp_code != 0xea ||
     ((biosmain_addr=jmp_off+jmp_seg*16) & 0xffff8000) != 0x000f8000) {
    BX_PANIC(("disk bios:unsupported BIOS ROM. contact me.\n"));
    return;
  }
  bx_cpu.regist_bioshook(HOOK_ROM,
			 biosmain_addr & 0x3ffff,
			 0,
			 bios_handler,
			 this);
  bx_cpu.regist_bioshook(HOOK_SINT,
			 0x93,
			 0,
			 bios_handler,
			 this);

  if(!bx_options.cd_hardware_emulation) {
#if BX_USE_CDBIOS_SMF
    BX_DISK_BIOS_THIS cd = & bx_cd_bios;
#else
    BX_DISK_BIOS_THIS cd = new bx_cd_bios_c();
#endif
    BX_DISK_BIOS_THIS cd->init(b, this);
  }

  if(!bx_options.fd_hardware_emulation) {
#if BX_USE_FDBIOS_SMF
    BX_DISK_BIOS_THIS fd = & bx_fd_bios;
#else
    BX_DISK_BIOS_THIS fd = new bx_fd_bios_c();
#endif
    BX_DISK_BIOS_THIS fd->init(b, this);
  }

  if(!bx_options.hd_hardware_emulation) {
#if BX_USE_HDBIOS_SMF
    BX_DISK_BIOS_THIS hd = & bx_hd_bios;
#else
    BX_DISK_BIOS_THIS hd = new bx_hd_bios_c();
#endif
    BX_DISK_BIOS_THIS hd->init(b, this);
  }
}

  void
bx_disk_bios_c::bios_handler(void *this_ptr,
			     BX_CPU_C *cpu,
			     int type,
			     Bit32u addr,
			     Bit32u errorno,
			     Boolean isPM,
			     int &exittype,
			     Bit32u &exitaddr,
			     Bit16u &exitseg,
			     Bit64u &leasttime,
			     Bit64u &maxtime)
{
#if !BX_USE_DISKBIOS_SMF
  bx_disk_bios_c *class_ptr = (bx_disk_bios_c *) this_ptr;

  class_ptr -> bios_exec(cpu,
			 type,			 
			 addr,
			 errorno,
			 isPM,
			 exittype,
			 exitaddr,
			 exitseg,
			 leasttime,
			 maxtime);
}

  void
bx_disk_bios_c::bios_exec(BX_CPU_C *cpu,
			  int type,
			  Bit32u addr,
			  Bit32u errorno,
			  Boolean isPM,
			  int &exittype,
			  Bit32u &exitaddr,
			  Bit16u &exitseg,
			  Bit64u &leasttime,
			  Bit64u &maxtime)
{
#else
  UNUSED(this_ptr);
#endif  // !BX_USE_DISKBIOS_SMF
  switch(AL & 0xf0) {
  case 0xc0:
    if(!bx_options.cd_hardware_emulation) {
      BX_DISK_BIOS_THIS cd -> bios_exec(cpu,
					type,
					addr,
					errorno,
					isPM,
					exittype,
					exitaddr,
					exitseg,
					leasttime,
					maxtime);
      return;
    } else {
      break;
    }

  case 0x20:
    if(!bx_options.fd_hardware_emulation) {
      BX_DISK_BIOS_THIS fd -> bios_exec(cpu,
					type,
					addr,
					errorno,
					isPM,
					exittype,
					exitaddr,
					exitseg,
					leasttime,
					maxtime);
      return;
    } else {
      break;
    }

  case 0xb0:
    if(!bx_options.hd_hardware_emulation) {
      BX_DISK_BIOS_THIS hd -> bios_exec(cpu,
					type,
					addr,
					errorno,
					isPM,
					exittype,
					exitaddr,
					exitseg,
					leasttime,
					maxtime);
      return;
    } else {
      break;
    }
  }

  BX_INFO(("unknown disk BIOS: call %d %.8x %d:\n",type,addr,isPM));
  cpu->atexit();

  maxtime=0;
  exittype=HOOK_END_ORIG;
}
